<?php

session_start();

require __DIR__ . "/../db/database.php";

?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lasītava</title>
    <link rel="stylesheet" href="homepage.css"> 
</head>

<body>
    <!-- Virsraksta sadaļa, parāda saites atkarībā no lietotāja pieslēguma statusa -->
    <div class="topSection">
        <?php if (isset($_SESSION["user_id"])): ?>
            <a href="../login/logout.php" id="logout">Izrakstīties</a>

        <?php else: ?>
            <a href="../login/login.php" id="login">Autorizēties</a>
            <a href="../register/register.php" id="register">Reģistrēties</a>

        <?php endif; ?>
    </div>
    
    <h1>Lasītava</h1>
        
    <!-- Sadaļa, kas satur galvenās funkcijas, lai varētu atrast vēlamo grāmatu -->
    <div class="middleSection">
        <div class="selectContent">
            <span id="letterRow">
                <button onclick="toggleLetter('A')">A</button>
                <button onclick="toggleLetter('Ā')">Ā</button>
                <button onclick="toggleLetter('B')">B</button>
                <button onclick="toggleLetter('C')">C</button>
                <button onclick="toggleLetter('Č')">Č</button>
                <button onclick="toggleLetter('D')">D</button>
                <button onclick="toggleLetter('E')">E</button>
                <button onclick="toggleLetter('Ē')">Ē</button>
                <button onclick="toggleLetter('F')">F</button>
                <button onclick="toggleLetter('G')">G</button>
                <button onclick="toggleLetter('Ģ')">Ģ</button>
                <button onclick="toggleLetter('H')">H</button>
                <button onclick="toggleLetter('I')">I</button>
                <button onclick="toggleLetter('Ī')">Ī</button>
                <button onclick="toggleLetter('J')">J</button>
                <button onclick="toggleLetter('K')">K</button>
                <button onclick="toggleLetter('Ķ')">Ķ</button>
                <button onclick="toggleLetter('L')">L</button>
                <button onclick="toggleLetter('Ļ')">Ļ</button>
                <button onclick="toggleLetter('M')">M</button>
                <button onclick="toggleLetter('N')">N</button>
                <button onclick="toggleLetter('Ņ')">Ņ</button>
                <button onclick="toggleLetter('O')">O</button>
                <button onclick="toggleLetter('P')">P</button>
                <button onclick="toggleLetter('R')">R</button>
                <button onclick="toggleLetter('S')">S</button>
                <button onclick="toggleLetter('Š')">Š</button>
                <button onclick="toggleLetter('T')">T</button>
                <button onclick="toggleLetter('U')">U</button>
                <button onclick="toggleLetter('Ū')">Ū</button>
                <button onclick="toggleLetter('V')">V</button>
                <button onclick="toggleLetter('Z')">Z</button>
                <button onclick="toggleLetter('Ž')">Ž</button>
            </span>
            <input id="search" type="text" placeholder="Meklēt...">
        </div>
    
    </div>

    <!-- Satura sadaļa -->
    <div class="contentContainer">
        <!-- Grāmatas izkārtojums -->
        <div class="card">
            <div class="image">
                <img src="" alt="">
            </div>
            <div class="info">
                <h2 class="heading"></h2>
                <p class="description"></p>
            </div>
        </div>
    </div>
    
    <!-- Grāmatas loga izkārtojums -->
    <div id="popup" class="popup" style="display: none">
    <div class="popup-content">
        <span class="close-btn" onclick="closePopup()">&times;</span>
        <div class="popup-book-info">
            <div class="popup-book-image">
                <img id="popup-book-image" src="" alt="">
            </div>
            <div class="popup-book-details">
                <h2 id="popup-book-title"></h2>
                <p id="popup-book-rating"></p>
                <a href="" id="popup-book-review"></a>
                <p id="popup-book-description"></p>
            </div>
        </div>
    </div>
    </div>

    <script>
    // Funkcija, kas pārslēdz loga redzamību, kad logs ir atvērts/aizvērts
    function togglePopup(bookId) {
        var popup = document.getElementById("popup");
        if (popup.style.display === "block") {

            closePopup();
        } else {
            openPopup(bookId);

        }
    }

    // Funkcija, kas atver logu, kad ir nospiesta grāmata
    function openPopup(bookId) {
        var xhr = new XMLHttpRequest();

        // Kad xhr ir pieprasīts un gatavs, tas izsauks funkciju, kas padarīs logu redzamu
        xhr.onreadystatechange = function() {
            if (xhr.readyState == 4 && xhr.status == 200) {

                document.getElementById("popup").innerHTML = xhr.responseText;
                document.getElementById("popup").style.display = "block";
            }
        };
        // Atver failu, kas satur grāmatas informāciju
        xhr.open('GET', 'getbookdetails.php?id=' + bookId, true);
        // Nosūta saņemto informāciju
        xhr.send();
    }

    // Funkcija, kas aizver logu
    function closePopup() {
        document.getElementById("popup").style.display = "none";
    }

    // Funkcija, kas meklē grāmatas pēc ievadītās informācijas
    function searchBooks(searchValue) {

        var xhr = new XMLHttpRequest();
        xhr.onreadystatechange = function() {
            if (xhr.readyState == 4 && xhr.status == 200) {
                appendBooks(xhr.responseText);
            }
        };

        xhr.open('GET', 'searchbooks.php?search=' + encodeURIComponent(searchValue), true);
        xhr.send();
    }

    // Ja vērtība mainās, tad tiek izsaukta funkcija, kas pieņem jauno vērtību
    document.getElementById("search").addEventListener("change", function(e){
        searchBooks(e.target.value);
    });

    // Funkcija, kas pārslēdz burtus uz aktīviem vai neaktīviem
    function toggleLetter(letter) {
        var buttons = document.querySelectorAll('#letterRow button');
        buttons.forEach(function(btn) {
            
            //Pārbauda, vai burts ir nospiests
            if (btn.textContent === letter) {
                //Ja ir, tas ir aktīvs
                btn.classList.toggle('active');

                //Pārbauda, vai burts ir aktīvs
                if (btn.classList.contains('active')) {
                    //Ja ir, tad iegūst visas grāmatas, kas sākas uz konkrētā burta
                    fetchBooks(letter);

                } else {
                    //Ja nav, netiek parādītas grāmatas
                    fetchBooks('');
                }
            } else {
                // Ja nav, tad tas ir neaktīvs 
                btn.classList.remove('active');
            }
        });
    }

    // iegūst visas grāmatas pēc parametra
    function fetchBooks(letter = "") {
        var xhr = new XMLHttpRequest();

        xhr.onreadystatechange = function() {
            if (xhr.readyState == 4 && xhr.status == 200) {
                appendBooks(xhr.responseText);
            }
        };
    
        xhr.open('GET', 'getbooks.php?letter=' + letter, true);
        xhr.send();
    }   
    // Funkcija, kas pievieno iegūtos grāmatu datus pie grāmatas kartiņas konteinera
    function appendBooks(booksHTML) {
        var contentContainer = document.querySelector('.contentContainer');
        contentContainer.innerHTML = '';

        contentContainer.insertAdjacentHTML('beforeend', booksHTML); 

        var cards = contentContainer.querySelectorAll('.card')

        // Funkcija, kura pie katras grāmatas kartiņas pievienos grāmatas logu, kuru var pārslēgt
        cards.forEach(function(card) {
            card.addEventListener('click', function() {
                var bookId = this.dataset.bookid;
                togglePopup(bookId);
            });
        });
    }

    // Iegūst visas grāmatas
    fetchBooks();
    </script>

</body>
</html>